import React from 'react'
import propTypes from 'prop-types'
import dynamic from 'next/dynamic'
import styled, { withTheme } from 'styled-components'

import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'
import { HorizontalLinkBar } from '@aller/shiny/src/molecules/HorizontalLinkBar'

const startLogoImg = 'https://sol.no/s/img/h_36/static/site-icons/start.no.png'

const KvasirSearchField = dynamic(() =>
	import(/* webpackChunkName: "KvasirSearchField" */ '../SOLComponents/KvasirSearchField'),
)
const Weather = dynamic(() => import(/* webpackChunkName: "Weather" */ '../Weather/Weather'))
const FormattedDateAndTime = dynamic(() =>
	import(
		/* webpackChunkName: "FormattedDateAndTime" */ '../SOLComponents/FormatedDateAndTime/FormattedDateAndTime'
	),
)

const LogoLink = styled(BlockLink)`
	margin: 0.8rem ${getVariable('horizontalBase')};
	width: 12.8rem;
	height: 3.8rem;
`
const BrandBar = ({
	theme: {
		colors: { primary },
	},
	preventClockUpdate,
	preventWeatherUpdate,
	...rest
}) => (
	<HorizontalLinkBar
		background={primary}
		zIndex={6}
		overflow="visible"
		shouldFlexChildren
		{...rest}
	>
		<LogoLink href="https://www.start.no/" flex="0 0 auto" aria-label="Start">
			<img src={startLogoImg} alt="start.no" title="start.no" />
		</LogoLink>
		<FormattedDateAndTime flex="1 0 auto" preventUpdate={preventClockUpdate} {...rest} />
		<Weather flex="2 0 auto" preventUpdate={preventWeatherUpdate} />
		{/* <LoginLink flex="0 0 auto" /> */}
		<KvasirSearchField flex="0 0 auto" defaultWidth="16rem" />
	</HorizontalLinkBar>
)

BrandBar.propTypes = {
	theme: propTypes.shape({
		colors: propTypes.shape({
			primary: propTypes.string.isRequired,
		}).isRequired,
	}).isRequired,
	preventClockUpdate: propTypes.bool,
	preventWeatherUpdate: propTypes.bool,
}
BrandBar.defaultProps = {
	preventClockUpdate: false,
	preventWeatherUpdate: false,
}

export default withTheme(BrandBar)
