import React from 'react'
import propTypes from 'prop-types'
import { withTheme } from 'styled-components'

/* eslint-disable max-len */
const SOLLogo = props => {
	const {
		theme: { colors = {} },
	} = props

	return (
		<svg width="100%" height="100%" viewBox="0 0 25 25">
			<circle fill={colors.primary} cx="12" cy="12" r="12" />
			<path
				d="M7.056,7.008 C8.568,7.008 9.36,7.92 9.36,9.504 L9.36,9.816 L7.896,9.816 L7.896,9.408 C7.896,8.688 7.608,8.424 7.128,8.424 C6.624,8.424 6.36,8.688 6.36,9.408 C6.36,11.448 9.408,11.832 9.408,14.664 C9.408,16.248 8.616,17.16 7.08,17.16 C5.544,17.16 4.752,16.248 4.752,14.664 L4.752,14.064 L6.216,14.064 L6.216,14.784 C6.216,15.504 6.528,15.744 7.032,15.744 C7.536,15.744 7.848,15.48 7.848,14.784 C7.848,12.744 4.8,12.36 4.8,9.528 C4.752,7.92 5.544,7.008 7.056,7.008 Z"
				fill={colors.white}
			/>
			<path
				d="M10.224,9.504 C10.224,7.92 11.064,7.008 12.6,7.008 C14.136,7.008 14.976,7.92 14.976,9.504 L14.976,14.664 C14.976,16.248 14.136,17.16 12.6,17.16 C11.064,17.16 10.224,16.248 10.224,14.664 L10.224,9.504 Z M11.784,14.76 C11.784,15.48 12.096,15.744 12.6,15.744 C13.104,15.744 13.416,15.48 13.416,14.76 L13.416,9.408 C13.416,8.688 13.104,8.424 12.6,8.424 C12.096,8.424 11.784,8.688 11.784,9.408 L11.784,14.76 Z"
				fill={colors.white}
			/>
			<path
				d="M19.296,17.04 C19.032,17.064 18.84,17.064 18.552,17.064 C17.376,17.064 16.32,16.56 16.32,14.568 L16.32,7.128 L17.88,7.128 L17.88,14.688 C17.88,15.456 18.288,15.648 18.768,15.648 C18.936,15.648 19.128,15.648 19.296,15.624 L19.296,17.04 L19.296,17.04 Z"
				fill={colors.white}
			/>
		</svg>
	)
}
SOLLogo.propTypes = {
	theme: propTypes.shape({
		colors: propTypes.shape({
			primary: propTypes.string.isRequired,
			white: propTypes.string.isRequired,
		}).isRequired,
	}).isRequired,
}

export default withTheme(SOLLogo)
