import React from 'react'
import styled from 'styled-components'

import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'
// import Auth, { loggedInPageUrl, loginPageUrl } from '../../../../services/auth'

const Link = styled(BlockLink)`
	padding: 0.9rem ${getVariable('horizontalBase')};
	color: #fff;
`

const LoginLink = () => {
	if (!(typeof window !== 'undefined')) {
		return null
	}

	const loginPageUrl = 'https://sol.no'

	// if (Auth.isAuthenticated()) {
	// 	window.dataLayer = window.dataLayer || []
	// 	window.dataLayer.push({
	// 		userAuthed: true,
	// 		userWebSignup: localStorage.getItem('webSignup') === 'true'
	// 	})
	//
	// 	return (
	// 		<Link href={loggedInPageUrl} flex="0 0 auto" aria-label="Se din profil">
	// 			Profil
	// 		</Link>
	// 	)
	// }
	return (
		<Link href={loginPageUrl} flex="0 0 auto" aria-label="Logg inn på sol.no">
			Logg inn
		</Link>
	)
}

export default LoginLink
