import ucfirst from 'ucfirst'

import { format, getISOWeek } from 'date-fns'
import { nb } from 'date-fns/locale'

const options = {
	locale: nb,
}

export default function getNewDateTime(args) {
	const now = args ? new Date(args) : new Date()
	return {
		date: ucfirst(format(now, 'eeee d. MMMM', options)),
		week: `Uke ${getISOWeek(now)}`,
		time: format(now, 'HH:mm', options),
	}
}
