import React from 'react'
import propTypes from 'prop-types'

import styled from 'styled-components'

const Bold = styled.span`
	font-weight: 600;
`

const TheTime = ({ datetime }) => {
	const { time } = datetime
	return <Bold>{time}</Bold>
}

TheTime.propTypes = {
	datetime: propTypes.shape({
		time: propTypes.string,
	}),
}

TheTime.defaultProps = {
	datetime: {
		time: '',
	},
}

export default TheTime
