import React from 'react'
import propTypes from 'prop-types'

const TheDate = ({ datetime }) => {
	const { date } = datetime

	return <time>{date}</time>
}

TheDate.propTypes = {
	datetime: propTypes.shape({
		date: propTypes.string,
	}),
}

TheDate.defaultProps = {
	datetime: {
		date: '',
	},
}

export default TheDate
