import React from 'react'
import propTypes from 'prop-types'
import styled, { withTheme } from 'styled-components'

import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'
import { HorizontalLinkBar } from '@aller/shiny/src/molecules/HorizontalLinkBar'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import Weather from '../Weather/Weather'
import KvasirSearchField from './KvasirSearchField'

import FormattedDateAndTime from './FormatedDateAndTime/FormattedDateAndTime'

import SOLLogo from './SOLLogo'

const LogoLink = styled(BlockLink)`
	margin: 0.8rem ${getVariable('horizontalBase')};
	width: 3.8rem;
	height: 3.8rem;
`

const BrandBar = ({
	theme: {
		colors: { secondary },
	},
	preventClockUpdate,
	preventWeatherUpdate,
	...rest
}) => (
	<HorizontalLinkBar
		background={secondary}
		zIndex={6}
		overflow="visible"
		shouldFlexChildren
		{...rest}
	>
		<LogoLink href="https://sol.no/" flex="0 0 auto" aria-label="SOL">
			<SOLLogo />
		</LogoLink>
		<FormattedDateAndTime flex="1 0 auto" preventUpdate={preventClockUpdate} {...rest} />
		<Weather flex="2 0 auto" preventUpdate={preventWeatherUpdate} />
		{/* <LoginLink flex="0 0 auto" /> */}
		<KvasirSearchField flex="0 0 auto" />
	</HorizontalLinkBar>
)
BrandBar.propTypes = {
	theme: propTypes.shape({
		colors: propTypes.shape({
			secondary: propTypes.string.isRequired,
		}).isRequired,
	}).isRequired,
	preventClockUpdate: propTypes.bool,
	preventWeatherUpdate: propTypes.bool,
}
BrandBar.defaultProps = {
	preventClockUpdate: false,
	preventWeatherUpdate: false,
}

export default withTheme(BrandBar)
