import React from 'react'
import styled from 'styled-components'

import { LinkBarLink, SmallLinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'

import { LinkBarDropdown } from '@aller/shiny/src/atoms/LinkBarDropdown'
import { VerticalLinkBar } from '@aller/shiny/src/molecules/VerticalLinkBar'
import { HorizontalLinkBar } from '@aller/shiny/src/molecules/HorizontalLinkBar'

import { Heading } from '@aller/shiny/src/atoms/Heading'

const linkProps = {
	useUnderline: false,
	activeBackground: '#dbd5ca',
	textColor: 'primary',
	style: {
		fontWeight: 300,
	},
}

const logoProps = {
	...linkProps,
	activeBackground: 'transparent',
}

const DagbladetHeader = styled(Heading)`
	margin: 2rem 3rem 2rem 2rem;
`

const MedialabenHeader = () => (
	<header>
		<HorizontalLinkBar
			isTopLevelComponent // Use the full width?
			background="#ffffff" // A refactor to bacground='splashBackground' is on the books
			shouldFlexChildren
			justifyContent="space-between"
			overflow="visible"
			zIndex={5}
		>
			<Heading xs sm={false}>
				Aller Innovasjon og Utvikling
			</Heading>

			<LinkBarDropdown xs sm={false} linkText="☰" textColor="type">
				<VerticalLinkBar background="white" align="right">
					<LinkBarLink linkText="Medialaben" url="/" {...linkProps} />
					<LinkBarLink linkText="Nyheter" url="/nyheter" {...linkProps} />
					<LinkBarLink linkText="Guider" url="/guider" {...linkProps} />
					<LinkBarLink linkText="Info" url="/info" {...linkProps} />
					<LinkBarLink linkText="Om oss" url="https://deluxe.medialaben.no/guide" {...linkProps} />
				</VerticalLinkBar>
			</LinkBarDropdown>
		</HorizontalLinkBar>
		<HorizontalLinkBar
			background="#f3f3f3" // A refactor to bacground='splashBackground' is on the books
			overflow="visible" // We need this for dropdowns
			isTopLevelComponent={false} // Use the full width
		>
			<DagbladetHeader xs={false} sm>
				{' '}
				Aller Innovasjon og Utvikling{' '}
			</DagbladetHeader>
			<SmallLinkBarLink
				xs={false}
				{...logoProps}
				isBlockLink
				style={{ maxWidth: '14.8rem' }}
				url="https://www.medialaben.no/"
			/>

			<LinkBarLink xs={false} sm linkText="Medialaben" url="https://www.medialaben.no" />
			<LinkBarLink xs={false} sm linkText="Nyheter" url="https://www.medialaben.no/nyheter" />
			<LinkBarLink xs={false} sm linkText="Guider" url="https://www.medialaben.no/guider" />
			<LinkBarLink xs={false} sm linkText="Info" url="https://www.medialaben.no/info" />
			<LinkBarLink xs={false} sm linkText="Om oss" url="https://deluxe.medialaben.no/guide" />
		</HorizontalLinkBar>
	</header>
)

export default MedialabenHeader
