/**
 * Custom Trigger for dropdown menus in KKHeader.
 *
 * Why do we need this? Because I decided to hack the font-sizes in the
 * LinkBarLinks in the menu. Because of that, we need this custom Trigger
 * in order to hack the font-sizes there as well.
 *
 * This is also the first place we're using a dorris icon in a button.
 */
import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'

import { LinkBarButton } from '@aller/shiny/src/atoms/LinkBarButton'
import ArrowDown from '@aller/shiny/src/atoms/SvgIcon/dorris/ArrowDown'
import ArrowUp from '@aller/shiny/src/atoms/SvgIcon/dorris/ArrowUp'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Button = styled(LinkBarButton)`
	font-size: ${getVariable('uiSmallSize')};
	line-height: 3.6rem;
	font-weight: 700;
`

const Trigger = props => {
	const { linkText, hide, ...rest } = props

	return (
		<Button {...rest}>
			{linkText}{' '}
			{hide ? (
				<ArrowDown height="13px" width="13px" fill="#000" />
			) : (
				<ArrowUp height="13px" width="13px" fill="#000" />
			)}
		</Button>
	)
}
Trigger.displayName = 'Trigger'
Trigger.propTypes = {
	hide: PropTypes.bool,
	linkText: PropTypes.string,
}
Trigger.defaultProps = {
	hide: false,
	linkText: '',
}

export default Trigger
