import React from 'react'
import propTypes from 'prop-types'
import { withTheme } from 'styled-components'
import dynamic from 'next/dynamic'

const BorsenHeader = dynamic(() => import('@aller/shared/components/header/BorsenHeader'))
const SeherHeader = dynamic(() => import('@aller/shared/components/header/SeherHeader'))
const KKHeader = dynamic(() => import('@aller/shared/components/header/KKHeader'))
const DagbladetHeader = dynamic(() => import('@aller/shared/components/header/DagbladetHeader'))
const DinsideHeader = dynamic(() => import('@aller/shared/components/header/DinsideHeader'))
const SOLHeader = dynamic(() => import('@aller/shared/components/header/SOLHeader'))
const Elbil24Header = dynamic(() => import('@aller/shared/components/header/Elbil24Header'))
const MedialabenHeader = dynamic(() => import('@aller/shared/components/header/MedialabenHeader'))
const StartHeader = dynamic(() => import('@aller/shared/components/header/StartHeader'))
const DagbladetVideoHeader = dynamic(() =>
	import('@aller/shared/components/header/DagbladetVideoHeader'),
)

const DynamicHeader = ({ theme, ...props }) => {
	switch (theme.name) {
		case 'Borsen':
			return <BorsenHeader {...props} />
		case 'DinSide':
			return <DinsideHeader {...props} />
		case 'SeHer':
			return <SeherHeader {...props} />
		case 'KK':
			return <KKHeader {...props} />
		case 'Elbil24':
			return <Elbil24Header {...props} />
		case 'SOL':
			return <SOLHeader {...props} />
		case 'Medialaben':
			return <MedialabenHeader {...props} />
		case 'Start':
			return <StartHeader {...props} />
		case 'DagbladetDark':
			return <DagbladetVideoHeader {...props} />
		default:
			return <DagbladetHeader {...props} />
	}
}

DynamicHeader.propTypes = {
	theme: propTypes.shape({ name: propTypes.string }),
}

DynamicHeader.defaultProps = {
	theme: {},
}

export default withTheme(DynamicHeader)
