import React from 'react'
import dynamic from 'next/dynamic'
import styled from 'styled-components'

import { LinkBarLink, LargeLinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'
import { LargeLinkBarSearchField } from '@aller/shiny/src/atoms/LinkBarSearchField'
import { LargeLinkBarDropdown as DinsideLargeDropdown } from '@aller/shiny/src/atoms/LinkBarDropdown'
import { Col } from '@aller/shiny/src/atoms/Col'
import { VerticalLinkBar } from '@aller/shiny/src/molecules/VerticalLinkBar'
import { HorizontalLinkBar } from '@aller/shiny/src/molecules/HorizontalLinkBar'
import { Header } from '@aller/shiny/src/atoms/Header'
import { getColor, getVariable } from '@aller/shiny/src/utils'
import { ScrollArrowsLinkBar as ShinyScrollBar } from '@aller/shiny/src/molecules/ScrollArrowsLinkBar'

import { LogoLink } from './shared/LogoLink'

const DinsideSearch = styled(Col)`
	position: absolute;
	right: 0;
	top: 0;
	z-index: 10;
	&& span[name='search'] {
		pointer-events: none;
		font-size: 1.8rem;
	}

	&& input[type='search'] {
		transition: width 0.3s cubic-bezier(0, 0.795, 0, 1);
		width: 5rem;
		margin: 0.5rem;
		padding-left: 2.4rem;
		:focus {
			width: 20rem;
			padding-left: 4.4rem;
			border: 0.1rem solid ${getColor('secondary')};
		}
		@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.lg}em) {
			width: inherit;
			padding-left: 4.4rem;
			margin-top: 1rem;
			:focus {
				width: inherit;
			}
		}
	}
`

const LargeLinkBarDropdown = styled(DinsideLargeDropdown)`
	span {
		font-size: ${getVariable('uiTinySize')};
	}
`

const ScrollArrowsLinkBar = styled(ShinyScrollBar)`
	border-bottom: solid 0.5px ${getColor('grayTintLight')};
	display: block;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		display: none;
	}
`

const linkProps = {
	useUnderline: false,
	activeBackground: '#dbd5ca',
	textColor: 'secondary',
	xs: false,
	md: true,
	style: {
		fontWeight: 300,
	},
}

const scrollArrowProps = {
	md: false,
	textColor: 'secondary',
}

const logoProps = {
	activeBackground: 'transparent',
}
const dropDownLinkProps = {
	useUnderline: false,
	activeBackground: 'rgba(0,0,0,0.05)',
}

const StyledHeader = styled(Header)`
	line-height: ${getVariable('headingXlargeLineHeight')};
	margin-bottom: 0;
`

const DinsideLogo = dynamic(() =>
	import(/* webpackChunkName: "DinsideLogo" */ '@aller/shiny/src/atoms/DinsideLogo').then(
		mod => mod.DinsideLogo,
	),
)
const DinsideHeader = () => (
	<StyledHeader>
		<HorizontalLinkBar
			background={getColor('splashBackground')}
			overflow="visible" // We need this for dropdowns
			isTopLevelComponent={false} // Use the full width
		>
			<LogoLink
				marginRight={2}
				smSize={11.8}
				{...logoProps}
				useUnderline={false}
				isBlockLink
				url="https://www.dinside.no/"
			>
				<DinsideLogo />
			</LogoLink>
			<LargeLinkBarLink {...linkProps} linkText="Motor" url="https://www.dinside.no/motor" />
			<LargeLinkBarLink {...linkProps} linkText="Teknologi" url="https://www.dinside.no/data" />
			<LargeLinkBarLink {...linkProps} linkText="Økonomi" url="https://www.dinside.no/okonomi" />
			<LargeLinkBarLink {...linkProps} linkText="Bolig" url="https://www.dinside.no/bolig" />
			<LargeLinkBarLink {...linkProps} linkText="Tester" url="https://www.dinside.no/tester" />
			<LargeLinkBarLink
				{...linkProps}
				linkText="Kalkulatorer"
				url="https://www.dinside.no/kalkulatorer"
			/>
			<LargeLinkBarDropdown {...linkProps} linkText="Snarveier" xs={false} md fontWeight="300">
				<VerticalLinkBar background="white">
					<LinkBarLink
						{...dropDownLinkProps}
						linkText="Fritid"
						url="https://www.dinside.no/fritid"
					/>
					<LinkBarLink {...dropDownLinkProps} linkText="Reise" url="https://www.dinside.no/reise" />
					<LinkBarLink
						{...dropDownLinkProps}
						linkText="Testpilot (annonsørinnhold)"
						url="http://testpilot.dinside.no"
					/>
					<LinkBarLink
						{...dropDownLinkProps}
						linkText="Rabattkode (annonsørinnhold)"
						url="https://www.dinside.no/rabattkode"
					/>
				</VerticalLinkBar>
			</LargeLinkBarDropdown>
			<DinsideSearch position="static">
				<LargeLinkBarSearchField
					icon="search"
					action="https://www.dinside.no/tekstarkiv"
					placeholder="Søk"
					backgroundColor="white"
				/>
			</DinsideSearch>
		</HorizontalLinkBar>
		<ScrollArrowsLinkBar
			background={getColor('white')}
			shouldAdjustForNestedPadding
			arrowSize="large"
		>
			<LinkBarLink {...scrollArrowProps} linkText="Motor" url="https://www.dinside.no/motor" />
			<LinkBarLink {...scrollArrowProps} linkText="Teknologi" url="https://www.dinside.no/data" />
			<LinkBarLink {...scrollArrowProps} linkText="Bolig" url="https://www.dinside.no/bolig" />
			<LinkBarLink {...scrollArrowProps} linkText="Økonomi" url="https://www.dinside.no/okonomi" />
			<LinkBarLink {...scrollArrowProps} linkText="Tester" url="https://www.dinside.no/tester" />
			<LinkBarLink
				{...scrollArrowProps}
				linkText="Kalkulatorer"
				url="https://www.dinside.no/kalkulatorer"
			/>
			<LinkBarLink {...scrollArrowProps} linkText="Fritid" url="https://www.dinside.no/fritid" />
			<LinkBarLink {...scrollArrowProps} linkText="Reise" url="https://www.dinside.no/reise" />
			<LinkBarLink
				{...scrollArrowProps}
				linkText="Testpilot (annonsørinnhold)"
				url="http://testpilot.dinside.no"
			/>
			<LinkBarLink
				{...scrollArrowProps}
				linkText="Rabattkode (annonsørinnhold)"
				url="https://www.dinside.no/rabattkode"
			/>
		</ScrollArrowsLinkBar>
	</StyledHeader>
)

export default DinsideHeader
