import styled, { css } from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'

const possibleSides = {
	top: 'top',
	right: 'right',
	bottom: 'bottom',
	left: 'left',
}

export const getBorder = props => `.1rem solid ${getColor('secondary')(props)}`

export default sides => WrappedComponent => styled(WrappedComponent)`
	${props => {
		return css`
			&& {
				border-top: ${sides.includes(possibleSides.top) ? getBorder(props) : 'none'};
				border-right: ${sides.includes(possibleSides.right) ? getBorder(props) : 'none'};
				border-bottom: ${sides.includes(possibleSides.bottom) ? getBorder(props) : 'none'};
				border-left: ${sides.includes(possibleSides.left) ? getBorder(props) : 'none'};
			}
		`
	}}
`
