import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'
import ShinyUserDropDown from '@aller/shiny/src/organisms/UserDropdown'
import { LargeLinkBarDropdown } from '@aller/shiny/src/atoms/LinkBarDropdown'
import VanillaDropdown from '../Vanilla/VanillaDropdown'
import { TruncatedTrigger } from './Trigger'

const linkProps = {
	useUnderline: false,
	activeBackgroundColor: 'primaryDark',
	textColor: 'darkness',
	activeTextColor: 'darkness',
	ALLCAPS: true,
	selector: 'dagbladet',
}
const StyledShinyUserDropdown = styled(ShinyUserDropDown)`
	&&& {
		right: -9.2rem;
		width: 30rem;
		@media screen and (width: ${({ theme }) => theme.flexboxgrid.breakpoints.sm}em) {
			right: 0;
		}
		@media screen and (max-width: ${({ theme }) => theme.flexboxgrid.breakpoints.sm}rem) {
			width: 100vw;
		}
	}
`
const Dropdown = styled(LargeLinkBarDropdown)`
	&& {
		max-height: 4.8rem;
	}
`

const HiddenVanillaDropdown = styled(VanillaDropdown)`
	&& {
		display: none;
	}
`

const UserDropDown = ({ selector }) => (
	<HiddenVanillaDropdown
		{...linkProps}
		textColor="white"
		activeTextColor="white"
		activeBackgroundColor="primary"
		Dropdown={Dropdown}
		id={`${selector}-dropdown-wrapper`}
		Trigger={TruncatedTrigger}
	>
		<StyledShinyUserDropdown
			id={`${selector}-dropdown`}
			align="right"
			uiSize="small"
			shouldFadeOut
			hideArrow
			user={{
				user_id: '',
				name: '',
			}}
		/>
		<script
			// eslint-disable-next-line react/no-danger
			dangerouslySetInnerHTML={{
				__html: `
						document.addEventListener("DOMContentLoaded", function() {
							// because when component is used as React component,
							// it will be reset to initial state by React
							window.setTimeout(processUser, 500);

							function processUser() {
								function parseDugStateCookie(cookieString) {
									if (!cookieString) {
										return undefined
									}
									switch (cookieString.charAt(0)) {
										case '{':
											return JSON.parse(cookieString)
										case 'e':
												return JSON.parse(atob(cookieString));
										case 'J':
												return JSON.parse(decodeURIComponent(atob(cookieString)));
										default:
											return undefined
									}
								}

								function getCookie(name) {
									var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
									if (match) return match[2];
								}

								const dugStateCookie = getCookie('dug-state')

								if (dugStateCookie) {
									const user = parseDugStateCookie(dugStateCookie);
									if (user && user.name) {
										user.name = user.name.replace('+', ' ')
									}

									if (user) {
										const loginButton = document.querySelector('#${selector}-login-button');

										if (loginButton) {
											// remove login button from header
											loginButton.parentNode.removeChild(loginButton);

											// set user info into dropdown trigger button
											const dropDownButton = document.querySelector('#${selector}-dropdown-button');
											dropDownButton.innerHTML = user.name;

											// set user info into dropdown field
											const dropdown = document.querySelector('#${selector}-dropdown');
											dropdown.querySelector("span").innerText = user.name;

											// show dropdown with user info
											const dropdownWrapper = document.querySelector('#${selector}-dropdown-wrapper');
											dropdownWrapper.style.display = "flex";
										}
									}
								}

								return;
							}
						});
					`,
			}}
		/>
	</HiddenVanillaDropdown>
)

UserDropDown.propTypes = {
	selector: PropTypes.string,
}
UserDropDown.defaultProps = {
	selector: 'dagbladet',
}

export default UserDropDown
