import styled from 'styled-components'
import { LinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import withBorder from './withBorder'

export default withBorder(['bottom'])(styled(LinkBarLink)`
	&& {
		transition: 0.2s;
		font-size: ${getVariable('uiSmallSize')};
		display: flex;
		flex-flow: row nowrap;
		align-items: center;
		justify-content: flex-start;
		width: 100%;
		white-space: nowrap;
		text-transform: capitalize;
	}
`)
