/* eslint-disable import/prefer-default-export */
import styled from 'styled-components'
import { LinkBarElementBase } from '@aller/shiny/src/atoms/LinkBarElementBase'
import { SvgIconWrapper } from '@aller/shiny/src/atoms/SvgIcon/SvgIconWrapper'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { getColor } from '@aller/shiny/src/utils/get-color'

// Vertically center the icon
export const IconButton = styled(LinkBarElementBase)`
	&& {
		display: flex;
		align-items: center;
		cursor: pointer;
		font-size: ${getVariable('uiSmallSize')};
		${SvgIconWrapper} {
			display: flex;
		}
		transition: 0.2s;
		@media screen and (min-width: ${({ theme }) => theme.flexboxgrid.breakpoints.sm}rem) {
			:hover {
				transition: 0.2s;
				background-color: ${getColor('primaryDark')};
			}
		}
	}
`
