import React from 'react'
import propTypes from 'prop-types'
import styled from 'styled-components'
import dynamic from 'next/dynamic'

const startLogoImg = 'https://sol.no/s/img/c_scale,h_38,w_38/static/site-icons/start-logo.png'

const LogoContainer = styled.div`
	width: 3.8rem;
	height: 3.8rem;
`

const FooterTag = dynamic(() =>
	import(/* webpackChunkName: "FooterTag" */ './SOLComponents/FooterTag'),
)
const Frame = dynamic(() => import(/* webpackChunkName: "Frame" */ './SOLComponents/Frame'))
const AppLinks = dynamic(() =>
	import(/* webpackChunkName: "AppLinks" */ './SOLComponents/AppLinks'),
)

const SOLFooter = ({
	Address,
	editorInChief: { name: editorInChiefName, email: editorInChiefEmail },
	cookieUrl,
	contactUrl,
	advertiseUrl,
}) => {
	return (
		<FooterTag>
			<Frame>
				<LogoContainer>
					<img src={startLogoImg} alt="start.no" title="start.no" />
				</LogoContainer>

				<AppLinks />

				<ul>
					<li>
						<a href={contactUrl}>Kontakt oss</a>
					</li>
					<li>
						<a href={advertiseUrl}>Annonsere</a>
					</li>
					<li>
						<a href={cookieUrl}>Om cookies</a>
					</li>
				</ul>

				<ul>
					<li>
						<strong>Besøksadresse:</strong>
						<a href="https://goo.gl/maps/ZiRWsUAjvEq">{Address}</a>
					</li>
					<li>
						<strong>Ansvarlig redaktør og adm dir:</strong>
						<a href={`mailto:${editorInChiefEmail}`}>{editorInChiefName}</a>
					</li>
					<li>
						<strong>Utgiverselskap:</strong>
						<a href="https://sol.no">Scandinavia Online AS</a>
					</li>
				</ul>
			</Frame>
		</FooterTag>
	)
}

SOLFooter.propTypes = {
	Address: propTypes.string,
	editorInChief: propTypes.shape({
		name: propTypes.string,
		email: propTypes.string,
	}),
	cookieUrl: propTypes.string,
	contactUrl: propTypes.string,
	advertiseUrl: propTypes.string,
}

SOLFooter.defaultProps = {
	Address: 'Karvesvingen 1, 0579 Oslo',
	editorInChief: {
		name: 'Jan Thoresen',
		email: 'jan.thoresen@aller.com',
	},
	cookieUrl: 'https://www.sol.no/nyheter/2013_07_02_19144_personvern-og-cookies.html',
	contactUrl: 'https://www.sol.no/hjelp',
	advertiseUrl: 'http://annonse.aller.no/',
}

export default SOLFooter
