import React from 'react'
import propTypes from 'prop-types'
import styled from 'styled-components'
import dynamic from 'next/dynamic'
import ConsoleSol from '../ConsoleSol'

import CouponLinks from '../CouponLinks'

const LogoContainer = styled.div`
	width: 3.8rem;
	height: 3.8rem;
`

const BottomParagraph = styled.p`
	text-align: center;
	margin-bottom: 0px;
	padding-bottom: 2.8rem;
`

const FooterTag = dynamic(() =>
	import(/* webpackChunkName: "FooterTag" */ './SOLComponents/FooterTag'),
)
const Frame = dynamic(() => import(/* webpackChunkName: "Frame" */ './SOLComponents/Frame'))
const AppLinks = dynamic(() =>
	import(/* webpackChunkName: "AppLinks" */ './SOLComponents/AppLinks'),
)
const SolLogo = dynamic(() =>
	import(/* webpackChunkName: "SOLLogo" */ '../header/SOLComponents/SOLLogo'),
)

const SOLFooter = ({
	Address,
	editorInChief: { name: editorInChiefName, email: editorInChiefEmail },
	assignmentEditor: { name: assignmentEditorName, email: assignmentEditorEmail },
	cookieUrl,
	contactUrl,
	advertiseUrl,
	aboutUrl,
}) => {
	return (
		<>
			<CouponLinks />
			<FooterTag className="lp_footer">
				<Frame>
					<LogoContainer>
						<SolLogo />
					</LogoContainer>

					<AppLinks />

					<ul>
						<li>
							<a href={aboutUrl}>Om SOL</a>
						</li>
						<li>
							<a href={contactUrl}>Kontakt oss</a>
						</li>
						<li>
							<a href={advertiseUrl}>Annonsere</a>
						</li>
						<li>
							<a href={cookieUrl}>Om cookies</a>
						</li>
					</ul>

					<ul>
						<li>
							<strong>Besøksadresse:</strong>
							<a href="https://goo.gl/maps/ZiRWsUAjvEq">{Address}</a>
						</li>
						<li>
							<strong>Ansvarlig redaktør og adm dir:</strong>
							<a href={`mailto:${editorInChiefEmail}`}>{editorInChiefName}</a>
						</li>
						<li>
							<strong>Redaktør:</strong>
							<a href="mailto:andreas.carlsen@aller.com">Andreas Heen Carlsen</a>
						</li>
						{assignmentEditorName && (
							<li>
								<strong>Vaktsjef nå:</strong>

								<a href={`mailto:${assignmentEditorEmail}`}>{assignmentEditorName}</a>
							</li>
						)}
					</ul>
				</Frame>
				<BottomParagraph>
					Utgitt av Scandinavia Online – et selskap i{' '}
					<a href="https://www.aller.no/">Aller Media</a>
				</BottomParagraph>
				<ConsoleSol />
			</FooterTag>
		</>
	)
}

SOLFooter.propTypes = {
	Address: propTypes.string,
	editorInChief: propTypes.shape({
		name: propTypes.string,
		email: propTypes.string,
	}),
	assignmentEditor: propTypes.shape({
		name: propTypes.string,
		email: propTypes.string,
	}),
	cookieUrl: propTypes.string,
	contactUrl: propTypes.string,
	advertiseUrl: propTypes.string,
	aboutUrl: propTypes.string,
}

SOLFooter.defaultProps = {
	Address: 'Karvesvingen 1, 0579 Oslo',
	editorInChief: {
		name: 'Jan Thoresen',
		email: 'jan.thoresen@aller.com',
	},
	assignmentEditor: {
		name: '',
		email: '',
	},
	cookieUrl: 'https://www.sol.no/nyheter/2013_07_02_19144_personvern-og-cookies.html',
	contactUrl: 'https://www.sol.no/hjelp',
	advertiseUrl: 'http://annonse.aller.no/',
	aboutUrl: 'https://www.sol.no/infoweb/om_sol',
}

export default SOLFooter
