import styled, { css } from 'styled-components'

import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { DontPushTheAdBoundaries } from '@aller/shiny/src/atoms/DontPushTheAdBoundaries'

const Frame = styled(DontPushTheAdBoundaries)`
	> * {
		margin: 0 calc(1 / 2 * ${getVariable('horizontalBase')}) ${getVariable('verticalBase')};
		flex-grow: 0;
		flex-shrink: 0;
		flex-basis: calc(100% - ${getVariable('horizontalBase')});
	}

	${props => {
		return props.zIndex
			? css`
					z-index: ${props.zIndex};
			  `
			: ''
	}};

	ul {
		padding: 0;

		li {
			margin-bottom: calc(1 / 2 * ${getVariable('verticalBase')});
		}

		&.links {
			li:last-child {
				margin-bottom: calc(1 / 4 * ${getVariable('verticalBase')});
			}
		}
	}

	@media screen and (min-width: ${getVariable('largeWidth')}) {
		> * {
			flex: 2 0 auto;
		}

		> *:first-child {
			margin-left: calc(1 / 2 * ${getVariable('horizontalBase')});
			flex-grow: 1;
		}

		> *:last-child {
			margin-right: calc(1 / 2 * ${getVariable('horizontalBase')});
		}
	}
`

export default Frame
