import styled from 'styled-components'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const FooterTag = styled.footer`
	font-family: 'Open Sans', 'Helvetica Neue', Helvetica, Arial, sans-serif;
	border-top: 1px solid ${getColor('grayTintLighter')};
	margin: 0;
	padding: ${getVariable('verticalBase')} 0 0 0;
	background-color: #fff;

	a {
		border: none;
	}

	strong {
		font-weight: ${getVariable('semiBoldWeight')};
		display: block;
	}

	ul {
		list-style-type: none;
	}
`

export default FooterTag
