import React from 'react'
import styled from 'styled-components'

const Link = styled.a`
	width: 13.5rem;
	height: 4rem;
	display: block;
	text-indent: -900rem;
`

const IosLink = styled(Link)`
	background-image: url(//sol.no/s/img/static/app-store-badge.svg);
`

const AndroidLink = styled(Link)`
	background-image: url(//sol.no/s/img/w_135/static/google-play-badge.jpg);
	background-size: contain;

	@media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
		background-image: url(//sol.no/s/img/w_270/static/google-play-badge.jpg);
	}
`

const AppLinks = () => (
	<ul>
		<li>
			<strong>Last ned SOL-appen</strong>
		</li>
		<li>
			<IosLink
				className="app-store-badge"
				href="https://itunes.apple.com/no/app/sol-no/id567951633?l=nb&mt=8"
			>
				App Store
			</IosLink>
		</li>
		<li>
			<AndroidLink
				className="google-play-badge"
				href="https://play.google.com/store/apps/details?id=no.sol&hl=no"
			>
				Google Play
			</AndroidLink>
		</li>
	</ul>
)

export default AppLinks
