import React from 'react'
import { Grid } from '@aller/shiny/src/atoms/Grid'
import { Row } from '@aller/shiny/src/atoms/Row'
import { Col } from '@aller/shiny/src/atoms/Col'
import PropTypes from 'prop-types'

import { Box, Footer, Ul, Li, Dl, Dd, Dt, Link } from './footer-components'

const MedialabenFooter = ({ assignmentEditor }) => {
	return (
		<Footer itemType="http://schema.org/Organization" itemScope="">
			<Grid>
				<Row>
					<Col xs={12} md={6} lg={6}>
						<Dl>
							<Dt>Postadresse:</Dt>
							<Dd itemProp="address" itemScope="" itemType="http://schema.org/PostalAddress">
								<span itemProp="postOfficeBoxNumber">Boks 1184</span> Sentrum,{' '}
								<span itemProp="postalCode">0107</span> <span itemProp="addressLocality">Oslo</span>
							</Dd>
							<Dt>Besøksadresse:</Dt>
							<Dd itemProp="location" itemScope="" itemType="http://schema.org/PostalAddress">
								<Link href="https://goo.gl/maps/EmpIH">
									<span itemProp="streetAddress">Karvesvingen 1</span>,{' '}
									<span itemProp="postalCode">0579</span>{' '}
									<span itemProp="addressLocality">Oslo</span>
								</Link>
							</Dd>
						</Dl>
					</Col>
					<Col xs={12} md={6} lg={6}>
						<Ul>
							<Li>
								<Link href="http://www.aller.no/personvern">Personvernavtale</Link>
							</Li>
							<Li>
								<Link href="http://www.mediebedriftene.no/informasjonskapsler">
									Om informasjonskapsler
								</Link>
							</Li>
						</Ul>
						<Box>
							<div itemScope="" itemType="http://schema.org/Person">
								<span itemProp="jobTitle">Ansvarlig redaktør</span>:{' '}
								<Link href="mailto:anita.kristoffersen@dagbladet.no" itemProp="email">
									<span itemProp="name">Anita Kristoffersen</span>
								</Link>
							</div>
						</Box>
					</Col>
				</Row>
			</Grid>
		</Footer>
	)
}

MedialabenFooter.propTypes = {
	assignmentEditor: PropTypes.shape({
		email: PropTypes.string.isRequired,
		name: PropTypes.string.isRequired,
	}),
}
MedialabenFooter.defaultProps = {
	assignmentEditor: {
		email: 'anita.kristoffersen@medialaben.no',
		name: 'Anita Kristoffersen',
	},
}

export default MedialabenFooter
