import React from 'react'
import Dynamic from 'next/dynamic'
import styled from 'styled-components'
import { Col } from '@aller/shiny/src/atoms/Col'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { LinkBarItem } from '@aller/shiny/src/atoms/LinkBarItem'
import { Paragraph } from '@aller/shiny/src/atoms/Paragraph'
import { Link } from '@aller/shiny/src/atoms/Link'

import GridRow from '../GridRow'

const Elbil24Logo = Dynamic(() =>
	import(/* webpackChunkName: "Elbil24Logo" */ '@aller/shiny/src/atoms/Elbil24Logo').then(
		c => c.Elbil24Logo,
	),
)

const Footer = styled.footer`
	color: ${getColor('white')};
	background-color: ${getColor('primary')};
	padding: calc(${getVariable('verticalBase')} * 2) 0;
	text-align: center;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		text-align: left;
	}
`

const Logo = styled(Col)`
	width: 18rem;
	margin: auto auto 3rem;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		margin: 0;
		svg {
			transition: transform 0.3s ease-in-out;
		}
	}
	& svg:hover {
		transform: scale(0.9);
	}
`

const Rights = styled(Col)`
	color: ${getColor('white')};
	background-color: ${getColor('secondary')};
	padding: 3rem 0.8rem;
	text-align: center;
	font-size: calc(${getVariable('headingRegularSize')} * 5 / 7);
`

const FooterLink = styled(Link)`
	color: ${getColor('white')};
	font-weight: ${getVariable('uiWeightSemiBold')};
	text-decoration: none;
`

const Contacts = styled(Col)`
	line-height: 1.7;
	p:first-child {
		padding-bottom: 2.25rem;
	}
	p {
		color: ${getColor('white')};
		padding: 0;
		margin: 0;
	}
`

const ElbilLinkBar = styled(LinkBarItem)`
	display: block;
	line-height: calc(${getVariable('uiTinyLineHeight')} * 2);
`

const MiddleBlock = styled(Col)`
	margin-top: 3rem;
	@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		margin-top: 0;
		padding-left: 6rem;
	}
`

const Elbil24Footer = () => (
	<>
		<Footer>
			<GridRow>
				<Col xs={12} md={4}>
					<Logo>
						<FooterLink href="https://www.elbil24.no">
							<Elbil24Logo inverted />
						</FooterLink>
					</Logo>
				</Col>
				<Col xs={12} md={4}>
					<Contacts>
						<Paragraph>
							Elbil24.no er Norges ledende nettavis dedikert til elbil og fremtidens mobilitet.
						</Paragraph>
						<Paragraph>
							Redaksjonssjef:{' '}
							<FooterLink href="mailto:fred.magne@elbil24.no">Fred Magne Skillebæk</FooterLink>
						</Paragraph>
						<Paragraph>
							Ansvarlig redaktør:{' '}
							<FooterLink href="mailto:jan.thoresen@aller.com">Jan Thoresen</FooterLink>
						</Paragraph>
						<Paragraph>
							Kundeservice: <FooterLink href="mailto:kundeservice@elbil24.no">Kontakt</FooterLink>
						</Paragraph>
					</Contacts>
				</Col>
				<MiddleBlock xs={12} md={4}>
					<ElbilLinkBar>
						<FooterLink href="https://www.elbil24.no/pro/dette-er-elbil24/70903004">
							Om oss
						</FooterLink>
					</ElbilLinkBar>
					<ElbilLinkBar>
						<FooterLink href="https://personvern.aller.no/">
							Redaksjonelle retningslinjer
						</FooterLink>
					</ElbilLinkBar>
					<ElbilLinkBar>
						<FooterLink href="https://personvern.aller.no/">
							Debatt, personvern og cookies
						</FooterLink>
					</ElbilLinkBar>
					<ElbilLinkBar>
						<FooterLink href="mailto:webmaster@aller.no">Teknisk feil på nettsiden?</FooterLink>
					</ElbilLinkBar>
					<ElbilLinkBar>
						<FooterLink href="http://www.mediebedriftene.no/informasjonskapsler">
							Om informasjonskapsler
						</FooterLink>
					</ElbilLinkBar>
					<ElbilLinkBar>
						<FooterLink href="http://annonse.aller.no/">Annonseinfo</FooterLink>
					</ElbilLinkBar>
				</MiddleBlock>
			</GridRow>
		</Footer>
		<Rights>
			<span>
				Utgitt av <FooterLink href="https://www.sol.no/">Scandinavia Online</FooterLink>– et selskap
				i<FooterLink href="https://www.aller.no/">Aller Media</FooterLink>
			</span>
		</Rights>
	</>
)

export default Elbil24Footer
