import React from 'react'
import propTypes from 'prop-types'
import { withTheme } from 'styled-components'
import dynamic from 'next/dynamic'

const SeherFooter = dynamic(() => import('@aller/shared/components/footer/SeherFooter'))
const DagbladetFooter = dynamic(() => import('@aller/shared/components/footer/DagbladetFooter'))
const DinsideFooter = dynamic(() => import('@aller/shared/components/footer/DinsideFooter'))
const SOLFooter = dynamic(() => import('@aller/shared/components/footer/SOLFooter'))
const StartFooter = dynamic(() => import('@aller/shared/components/footer/StartFooter'))
const KKFooter = dynamic(() => import('@aller/shared/components/footer/KKFooter'))
const DagbladetVideoFooter = dynamic(() =>
	import('@aller/shared/components/footer/DagbladetVideoFooter'),
)

const DynamicFooter = ({ theme, ...props }) => {
	switch (theme.name) {
		case 'DinSide':
			return <DinsideFooter {...props} />
		case 'SeHer':
			return <SeherFooter {...props} />
		case 'SOL':
			return <SOLFooter {...props} />
		case 'KK':
			return <KKFooter {...props} />
		// case 'Medialaben':
		// return <MedialabenFooter {...props} />
		case 'Start':
			return <StartFooter {...props} />
		case 'DagbladetDark':
			return <DagbladetVideoFooter {...props} />
		default:
			return <DagbladetFooter {...props} />
	}
}

DynamicFooter.propTypes = {
	theme: propTypes.shape({ name: propTypes.string }),
}

DynamicFooter.defaultProps = {
	theme: {},
}

export default withTheme(DynamicFooter)
