// Dependencies
import React from 'react'
import PropTypes from 'prop-types'

// Components for this module
// import { DotLoader as Loading } from '@aller/shiny/src/atoms/loaders/DotLoader'
// import Loading from './Loading'

import Main from './Main'
import Loading from './Loading'

// Our data fetching React component
const XavierArticles = ({ isLoadingData, error, context, ...rest }) => {
	const { xavierarticles } = context
	if (error) {
		return <div>Oops, something went wrong.</div>
	}
	// Handle data loading if you want
	// a loading indicator and not "dead" data:
	// Until we have data,
	// show a loading indicator

	if (xavierarticles && xavierarticles.length < 1) {
		return <Loading {...rest} />
	}

	// The actual stuff you want to show
	return <Main {...rest} context={context} />
}
XavierArticles.propTypes = {
	error: PropTypes.bool.isRequired,
	isLoadingData: PropTypes.bool.isRequired,
	context: PropTypes.shape({
		xavierarticles: PropTypes.arrayOf(PropTypes.shape({})),
	}).isRequired,
}

// Finally export the module
export default XavierArticles
