// Dependencies
import React from 'react'
import PropTypes from 'prop-types'

import { GenericAd } from '@aller/shiny/src/molecules/GenericAd'

// Local components
import XavierContentAd from '../XavierContentAd'
import XavierArticles from '../XavierArticles'
import { XavierContext } from '../../store/xavier'
import AdSlot from '../Ad/AdSlot'

class Main extends React.Component {
	componentDidMount() {
		const { context } = this.props
		context.fetchContentAds()
	}

	xavierArticle = (counter, context) => {
		return <XavierArticles context={context} column={{ xs: 12, md: 4 }} counter={counter} />
	}

	displayAd = id => {
		return (
			<AdSlot
				adSlotProps={{ id: `ad-medium-rectangle${id}` }}
				wrapperProps={{
					height: '250px',
				}}
				wrapper={GenericAd}
			/>
		)
	}

	contentAd = (elementCounter, context) => {
		return (
			<XavierContentAd
				context={context}
				column={{ xs: 12, md: 4 }}
				elementCounter={elementCounter}
			/>
		)
	}

	render() {
		const { elementCounter } = this.props

		if (elementCounter.xavierAndAd === 0) {
			return (
				<XavierContext.Consumer>
					{context => (
						<>
							{this.contentAd(elementCounter, context)}
							{this.xavierArticle(elementCounter.xavierArticle + 1, context)}
							{this.displayAd(elementCounter.displayAd)}
						</>
					)}
				</XavierContext.Consumer>
			)
		}

		if (elementCounter.xavierAndAd % 2 === 0) {
			return (
				<XavierContext.Consumer>
					{context => (
						<>
							{this.xavierArticle(elementCounter.xavierArticle, context)}
							{this.xavierArticle(elementCounter.xavierArticle + 1, context)}
							{this.displayAd(elementCounter.displayAd)}
						</>
					)}
				</XavierContext.Consumer>
			)
		}

		if (elementCounter.xavierAndAd % 2 !== 0) {
			return (
				<XavierContext.Consumer>
					{context => (
						<>
							{this.displayAd(elementCounter.displayAd)}
							{this.xavierArticle(elementCounter.xavierArticle, context)}
							{this.xavierArticle(elementCounter.xavierArticle + 1, context)}
						</>
					)}
				</XavierContext.Consumer>
			)
		}

		return null
	}
}

Main.propTypes = {
	elementCounter: PropTypes.shape({
		displayAd: PropTypes.number,
		xavierArticle: PropTypes.number,
		xavierAndAd: PropTypes.number,
	}).isRequired,
	context: PropTypes.shape({
		fetchContentAds: PropTypes.func.isRequired,
	}),
	column: PropTypes.shape({}),
}

Main.defaultProps = {
	column: {},
	context: {},
}

export default Main
