import styled from 'styled-components'
import { DymoHeading } from '@aller/shiny/src/atoms/DymoHeading'
import { getColor, getVariable } from '@aller/shiny/src/utils'

const VideoDymo = styled(DymoHeading)`
	&&&& {
		background-color: ${getColor('primary')};
		font-size: calc(2 / 3 * ${getVariable('headingRegularSize')});
		margin: 0 0 1rem;
		padding: 0 ${getVariable('uiTinySize')};
		letter-spacing: 0.1rem;
		@media screen and (min-width: ${props => props.theme.flexboxgrid.breakpoints.sm}em) {
			font-size: ${getVariable('headingSmallSize')};
		}
	}
`

export default VideoDymo
