import React from 'react'
import styled from 'styled-components'
import propTypes from 'prop-types'

import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

import User from '../User'
import StatisticTypeDropdown from '../StatisticTypeDropdown'
import Achievements from '../Achievements'

const Profile = styled.section`
	background-color: ${getColor('splashBackground')};
	display: flex;
	flex-direction: row;
	flex-wrap: wrap;
	justify-content: space-between;
	padding: ${getVariable('verticalBase')} ${getVariable('horizontalBase')};
`

const Header = styled.header`
	flex: 1 0 100%;
`

const UserProfile = props => {
	const { changeStatisticType, statisticType } = props

	return (
		<Profile>
			<Header>
				<StatisticTypeDropdown
					changeStatisticType={changeStatisticType}
					statisticType={statisticType}
				/>
			</Header>
			<User />
			<Achievements />
		</Profile>
	)
}

UserProfile.propTypes = {
	changeStatisticType: propTypes.func.isRequired,
	statisticType: propTypes.string,
}

UserProfile.defaultProps = {
	statisticType: 'daily',
}

export default UserProfile
