import React from 'react'
import styled from 'styled-components'

import { Heading as ShinyHeading } from '@aller/shiny/src/atoms/Heading'
import { Paragraph } from '@aller/shiny/src/atoms/Paragraph'
import { getColor } from '@aller/shiny/src/utils/get-color'

import UserImage from './UserImage'

const UserLevel = styled(Paragraph)`
	color: ${p => getColor(p.color)};
	font-style: italic;
`

const NameHeading = styled(ShinyHeading)`
	display: inline-block;
	color: ${p => getColor(p.color)};
`

const Name = props => <NameHeading size="small" {...props} />

const User = props => (
	<div>
		<UserImage />
		<Name color="white" {...props}>
			Ola Nordmann
		</Name>
		<UserLevel color="white">News Junkie</UserLevel>
	</div>
)

export default User
