import React from 'react'
import styled from 'styled-components'
import dynamic from 'next/dynamic'
import propTypes from 'prop-types'

import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { LinkBarLink } from '@aller/shiny/src/atoms/LinkBarLink'
import { MenuLayer } from '@aller/shiny/src/atoms/MenuLayer'
import { LargeLinkBarDropdown } from '@aller/shiny/src/atoms/LinkBarDropdown'
import { VerticalLinkBar } from '@aller/shiny/src/molecules/VerticalLinkBar'

const statisticTypes = {
	daily: 'denne dagen',
	weekly: 'denne uken',
}

const StyledMenuLayer = styled(MenuLayer)`
	position: absolute;
`

const VanillaDropdown = dynamic(() =>
	import(/* webpackChunkName: "VanillaDropdown" */ '../../header/Vanilla/VanillaDropdown'),
)

const styledLargeLinkBarDropdown = styled(LargeLinkBarDropdown)`
	&& {
		padding: 10px 0;
		color: white;

		&:focus:hover {
			background: none;
		}

		&:focus {
			background: none;
		}
	}
`

const StyledVanillaDropdown = styled(VanillaDropdown)`
	&& {
		font-size: ${getVariable('headingRegularSize')};
	}
`

const linkProps = {
	activeBackgroundColor: 'transparent',
	textColor: 'type',
	skin: 'splashBorder',
	ALLCAPS: true,
	useUnderline: false,
}

const StatisticTypeDropdown = props => {
	const { statisticType, changeStatisticType } = props
	const statisticTypeTitle = statisticTypes[statisticType]

	return (
		<StyledVanillaDropdown
			Dropdown={styledLargeLinkBarDropdown}
			id="statistic-menu"
			xs={false}
			lg
			zIndex={7}
			position="relative"
			textColor="white"
			linkText={`Din statistikk ${statisticTypeTitle}`}
			{...linkProps}
		>
			<StyledMenuLayer left="inherit">
				<VerticalLinkBar>
					<LinkBarLink
						onClick={changeStatisticType}
						data-value="daily"
						linkText="Denne dagen"
						{...linkProps}
					/>
					<LinkBarLink
						onClick={changeStatisticType}
						linkText="Denne uken"
						data-value="weekly"
						{...linkProps}
					/>
				</VerticalLinkBar>
			</StyledMenuLayer>
		</StyledVanillaDropdown>
	)
}

StatisticTypeDropdown.propTypes = {
	changeStatisticType: propTypes.func.isRequired,
	statisticType: propTypes.string.isRequired,
}

export default StatisticTypeDropdown
