import React from 'react'
import PropTypes from 'prop-types'
import MSlider from '@material-ui/lab/Slider'
import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Label = styled.div`
	&& {
		text-transform: capitalize;
		color: ${({ color }) => getColor(color)};
		text-shadow: 0.1rem 0.1rem 0.2rem black;
		font-size: ${getVariable('headingLargeSize')};
		line-height: ${getVariable('headingLargeLineHeight')};
		margin: ${getVariable('verticalBase')} 0;
	}
`

const StyledMSlider = styled(MSlider)`
	.MuiSlider-track-3 {
		height: 8px;
	}
`

// Mslider component works with material-ui Provider, need to rewrite for Shiny
const Slider = props => {
	const { label, textColor, ...rest } = props
	return (
		<>
			<Label color={textColor}>{label}</Label>
			<StyledMSlider {...rest} />
		</>
	)
}
Slider.propTypes = {
	label: PropTypes.string.isRequired,
	textColor: PropTypes.string,
	value: PropTypes.number,
}
Slider.defaultProps = {
	value: 0,
	textColor: 'type',
}
export default Slider
