import React, { Component } from 'react'
import PropTypes from 'prop-types'
import styled, { css, withTheme } from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'

const degreeToRad = degree => (degree * Math.PI) / 180

const Canvas = styled.div`
	${({ size }) => css`
		width: ${size};
		height: ${size};
	`}
`

class PolygonCanvas extends Component {
	element

	componentDidMount() {
		this.draw()
	}

	componentDidUpdate() {
		this.draw()
	}

	// Imagine a Triangle with sides a, b, c and angles A,B,C
	getCoord(vert, degree) {
		const startCoord = this.size / 2
		let A = 0
		let x
		let y
		if (degree < 90) {
			A = degree
		} else if (degree > 90 && degree < 180) {
			A = degree - 90
		} else if (degree > 180 && degree < 270) {
			A = degree - 180
		} else if (degree > 270 && degree < 360) {
			A = degree - 270
		}
		const c = startCoord * (vert / 100)
		const a = c * Math.sin(degreeToRad(A))
		const b = Math.sqrt(c * c - a * a)
		if (degree < 90) {
			x = startCoord + a
			y = startCoord - b
		} else if (degree > 90 && degree < 180) {
			x = startCoord + a
			y = startCoord + b
		} else if (degree > 180 && degree < 270) {
			x = startCoord - a
			y = startCoord + b
		} else if (degree > 270 && degree < 360) {
			x = startCoord - a
			y = startCoord - b
		}
		if (degree === 0 || degree === 360) {
			x = startCoord
			y = startCoord - c
		} else if (degree === 90) {
			x = startCoord + c
			y = startCoord
		} else if (degree === 180) {
			x = startCoord
			y = startCoord + c
		} else if (degree === 270) {
			x = startCoord - c
			y = startCoord
		}
		return { x, y }
	}

	get size() {
		const { size } = this.props
		return size * 0.95
	}

	// works only with for 4 interes, need to refactor, will be usefull: Math.sin(L) = a/c
	draw() {
		const {
			vertices,
			verticesText,
			size: realSize,
			primaryColor,
			secondaryColor,
			textColor,
			font,
			globalAlpha,
			shadowBlur,
			shadowColor,
		} = this.props
		const canvas = this.element
		const center = this.size / 2
		const degreeStep = Math.floor(360 / vertices.length)
		if (canvas.getContext) {
			const ctx = canvas.getContext('2d')
			ctx.globalAlpha = globalAlpha
			ctx.clearRect(0, 0, canvas.width, canvas.height)
			ctx.strokeStyle = getColor(secondaryColor)(this.props)
			ctx.beginPath()
			ctx.moveTo(center, realSize - this.size)
			ctx.lineTo(center, this.size)
			ctx.moveTo(realSize - this.size, center)
			ctx.lineTo(this.size, center)
			ctx.stroke()
			ctx.beginPath()
			ctx.shadowBlur = shadowBlur
			ctx.shadowColor = getColor(shadowColor)(this.props)
			ctx.fillStyle = getColor(primaryColor)(this.props)
			let degree = 0
			const coords = vertices.map((vert, index) => {
				const { x, y } = this.getCoord(vert, degree)
				if (index === 0) {
					ctx.moveTo(x, y)
				} else {
					ctx.lineTo(x, y)
				}
				degree += degreeStep
				return { x, y }
			})
			ctx.fill()
			ctx.font = font
			verticesText.map((text, index) => {
				ctx.fillStyle = getColor(textColor)(this.props)
				const { x, y } = coords[index]
				ctx.fillText(text, x, y)
				return text
			})
		}
	}

	render() {
		const { size } = this.props
		return (
			<Canvas size={size}>
				<canvas
					width={size}
					height={size}
					ref={element => {
						this.element = element
					}}
				/>
			</Canvas>
		)
	}
}

PolygonCanvas.propTypes = {
	primaryColor: PropTypes.string,
	secondaryColor: PropTypes.string,
	textColor: PropTypes.string,
	shadowBlur: PropTypes.number,
	shadowColor: PropTypes.string,
	size: PropTypes.number,
	globalAlpha: PropTypes.number,
	font: PropTypes.string,
	vertices: PropTypes.arrayOf(PropTypes.number).isRequired,
	verticesText: PropTypes.arrayOf(PropTypes.string),
}
PolygonCanvas.defaultProps = {
	size: 800,
	globalAlpha: 1,
	font: '18px serif',
	primaryColor: 'primary',
	secondaryColor: 'secondary',
	textColor: 'type',
	shadowBlur: 15,
	shadowColor: 'darknessLight',
	verticesText: [],
}

export default withTheme(PolygonCanvas)
