import React from 'react'
import styled from 'styled-components'
import PropTypes from 'prop-types'
import { BodyText } from '@aller/shiny/src/atoms/BodyText'

const Input = styled.input``
class NumInput extends React.Component {
	constructor(props) {
		super(props)
		const { value } = props
		this.state = { value }
	}

	handlechange = ({ target: { value } }) => {
		const { maxValue, minValue, onChange } = this.props
		const numVal = Number(value)
		if (minValue <= numVal && numVal <= maxValue) {
			onChange(numVal)
			this.setState({ value: numVal })
		}
	}

	render() {
		const { value } = this.state
		return <Input {...this.props} value={value} onChange={this.handlechange} />
	}
}
NumInput.propTypes = {
	onChange: PropTypes.func.isRequired,
	maxValue: PropTypes.number,
	minValue: PropTypes.number,
	value: PropTypes.number,
}

NumInput.defaultProps = {
	maxValue: 100,
	minValue: 0,
	value: 0,
}

const NumField = ({ placeholder, label, ...rest }) => (
	<>
		<BodyText>{label}</BodyText>
		<NumInput {...rest} placeholder={placeholder || label} maxValue={100} type="number" />
	</>
)
NumField.propTypes = {
	onChange: PropTypes.func.isRequired,
	label: PropTypes.string.isRequired,
	placeholder: PropTypes.string,
}
NumField.defaultProps = {
	placeholder: '',
}

export default NumField
export { NumInput }
