/* eslint-disable import/prefer-default-export */
import React from 'react'
import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import { Card } from './Card'

const Container = styled.ul`
	margin-bottom: ${getVariable('horizontalBase')};
	width: 100%;
	display: flex;
	justify-content: space-evenly;
	flex-wrap: wrap;
`

const cardsList = [
	{ title: 'E-post', link: 'https://www.mailia.no/webmail', color: '#000' },
	{ title: 'Quiz', link: 'https://sol.no/quiz', color: '#7a9a26' },
	{ title: 'SOL.no', link: 'https://sol.no', color: '#e20613' },
	{ title: 'Vi.no', link: 'https://vi.no', color: '#064163' },
	{ title: 'Striper', link: 'https://www.dagbladet.no/tegneserie/', color: '#d60000' },
	{ title: 'Været', link: 'https://sol.no/vaer', color: '#508fb6' },
	{ title: 'Horoskop', link: 'https://sol.no/horoskop', color: '#455c7b' },
	{ title: 'Kvasir', link: 'https://kvasir.no', color: '#be202e' },
	{ title: 'Elbil24', link: 'https://elbil24.no', color: '#d23829' },
	{ title: 'Kode24', link: 'https://kode24.no', color: '#c431e3' },
	{
		title: 'Kalkulatorer',
		link:
			'https://www.dinside.no/okonomi/regn-ut-alt-fra-promilleniva-til-nar-du-blir-millionaer/70292488',
		color: '#cc3612',
	},
	{
		title: 'Kryssord',
		link: 'https://www.vi.no/okonomi/dagens-minikryssord/70033312',
		color: '#064163',
	},
]

const Services = () => {
	const cards = cardsList.map((item, index) => (
		<Card key={`card${index}`} title={item.title} link={item.link} color={item.color} />
	))
	return <Container>{cards}</Container>
}

export { Services }
