/* eslint-disable import/prefer-default-export */
import React from 'react'
import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'
import Ad from '../Ad'

const Container = styled.section`
	margin-bottom: 4.5rem;
	@media screen and (min-width: ${getVariable('largeWidth')}) {
		grid-column: 3 / 4;
		grid-row: 3 / 6;
		width: 30rem;
		margin-bottom: none;
	}
`

const targeting = '{ "pos": "medium-rectangle%d", "platform": "wolverine" }'
const sizes = '[[320,250],[300,250],"fluid"]'

const MediumRectangle = () => (
	<Container>
		<Ad
			adUnit="8578/start/forside"
			id="ad-medium-rectangle"
			sizes={sizes}
			lazyload
			collapse={false}
			outofpage={false}
			targeting={targeting}
			width={100}
			size={{ width: '320px', height: '250px' }}
		/>
	</Container>
)

export { MediumRectangle }
