/* eslint-disable import/prefer-default-export, react/destructuring-assignment */

import React from 'react'
import propTypes from 'prop-types'
import styled from 'styled-components'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Outer = styled.a`
	flex: 1 0 auto;
	display: block;
	width: 100%;
	height: 6rem;
	position: relative;
	background: #fff;
	box-shadow: 0 5px 9px 0 rgba(0, 0, 0, 0.07);
	border-radius: 5px;
	letter-spacing: -0.12px;
	font-size: 1.7rem;
	text-decoration: none;
	margin: 1rem;
	flex-grow: 0;
	flex-basis: calc(50% - 20px);
	transition: box-shadow 0.15s ease-in-out;

	&:hover {
		box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
	}

	@media screen and (min-width: ${getVariable('largeWidth')}) {
		flex-grow: 1;
		flex-basis: auto;
		width: 20rem;
		height: 12rem;
		font-size: 2.4rem;
		margin: 0 4.5rem 4.5rem 0;
		box-shadow: 0 5px 14px 0 rgba(0, 0, 0, 0.1);
	}
`

const Inner = styled.span`
	margin: 0;
	position: absolute;
	top: 50%;
	left: 50%;
	margin-right: -50%;
	transform: translate(-50%, -50%);
	color: ${props => props.color};
	font-weight: bold;
	font-family: Montserrat-Bold, sans-serif;
`

const Card = props => {
	const { title, link, color } = props

	return (
		<Outer href={link}>
			<Inner color={color}>{title}</Inner>
		</Outer>
	)
}
Card.propTypes = {
	title: propTypes.string.isRequired,
	link: propTypes.string.isRequired,
	color: propTypes.string.isRequired,
}

export { Card }
