/* eslint-disable import/prefer-default-export */
import React from 'react'
import styled from 'styled-components'
import propTypes from 'prop-types'
import Ad from '../Ad'

const Container = styled.section`
	margin-left: -2rem !important;
`

const targeting = '{ "pos": "banner", "platform": "wolverine" }'
const sizes = '[[320,250],[300,250],"fluid"]'
const sizeMapping = [
	{
		viewport: JSON.stringify([0, 0]),
		slot: JSON.stringify([[320, 250], [300, 250], 'fluid']),
	},
	{
		viewport: JSON.stringify([1200, 0]),
		slot: JSON.stringify([[980, 300], [970, 250], 'fluid']),
	},
]

const Banner = props => {
	const { id } = props
	return (
		<Container>
			<Ad
				adUnit="/8578/start/forside"
				id={`ad-banner${id}`}
				sizes={sizes}
				lazyload
				collapse={false}
				outofpage={false}
				targeting={targeting}
				sizemapping={sizeMapping}
				size={{ width: '320px', height: '250px' }}
			/>
		</Container>
	)
}

Banner.propTypes = {
	id: propTypes.string.isRequired,
}

export { Banner }
