/* eslint-disable react/state-in-constructor, react/static-property-placement */
import React from 'react'
import propTypes from 'prop-types'
import styled from 'styled-components'

import { getVariable, getColor } from '@aller/shiny/src/utils'
import { TinyRoundedButton } from '@aller/shiny/src/atoms/RoundedButtons'
import Firebase from '../services/firebase'

const BubbleStyled = styled.div`
	display: flex;
	width: 100%;
	max-width: 360px;
	padding: 0;
`

const BubbleContent = styled.div`
	flex-grow: 1;

	line-height: ${getVariable('uiRegularLineHeight')};
`

const BubbleContentText = styled.div`
	border-radius: 1.5rem;
	border-top-left-radius: 0.3rem;
	border: 0.1rem solid ${getColor('grayTintLight')};
	padding: 0.8rem 1.2rem;
	font-size: ${getVariable('uiRegularSize')};

	background: ${getColor('white')};

	margin-bottom: 1rem;
`

const Button = styled(TinyRoundedButton)`
	font-size: 12;
	padding: 0.8rem 1.2rem 0.7rem;
	margin: 0.2rem 1rem 1rem 0rem;
`

class SolPush extends React.Component {
	static contextTypes = {
		settings: propTypes.shape({}),
	}

	state = {
		render: false,
	}

	componentDidMount() {
		if (localStorage.getItem('SolPushDismissed')) {
			return
		}

		this.enableRendering()
		this.firebase = new Firebase({})
	}

	handleClose = () => {
		localStorage.setItem('SolPushDismissed', true)
		this.setState({
			render: false,
		})
	}

	handleAccept = () => {
		this.firebase.setToken()
		localStorage.setItem('SolPushDismissed', true)
		this.setState({
			render: false,
		})
	}

	enableRendering() {
		this.setState({
			render: true,
		})
	}

	render() {
		const { render } = this.state
		if (!render) {
			return null
		}

		if (!Firebase.isSupported()) {
			return null
		}

		const { settings: { ua: { isMobile = false, isTablet = false } = {} } = {} } = this.context

		return (
			<div
				style={{
					position: 'relative',
					zIndex: 100,
				}}
			>
				<BubbleStyled isMobile={isMobile} isTablet={isTablet}>
					<BubbleContent>
						<BubbleContentText>
							Ønsker du varsler om de viktigste nyhetene i nettleseren?
						</BubbleContentText>
						<Button onClick={this.handleAccept} color="white" background="solBlue">
							Ja takk!
						</Button>
						<Button onClick={this.handleClose} color="white" background="solBlue">
							Nei
						</Button>
					</BubbleContent>
				</BubbleStyled>
			</div>
		)
	}
}

export default SolPush
