import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'

const Headline: any = styled.h1`
	font-family: 'Barlow', sans-serif;
	font-size: 2.4rem;
	line-height: 1.2;
	font-weight: 800;
	margin: 0;
	padding: 0 0 0.2em;

	.primary {
		color: ${getColor('solRed') || 'red'};
	}

	@media only screen and (min-width: 600px) {
		${prop => {
			if (!prop.fontSizeOverride || prop.fontSizeOverride === 0) {
				switch (prop.md) {
					case 12:
					case 11:
					case 10:
					case 9:
						return `
						font-size: 5.2rem;
						line-height: 1;
					`
					case 8:
					case 7:
						return `
						font-size: 4.2rem;
						line-height: 1;
					  `
					case 6:
					case 5:
						return `
						font-size: 3.2rem;
						line-height: 1;
					`
					case 4:
					case 3:
					case 2:
					case 1:
						return `
						font-size: 2.6rem;
						line-height: 1;
					`
					default:
						return `
						font-size: 3.2rem;
						line-height: 1;
					`
				}
			}
			return ''
		}}
	}

	@media only screen and (max-width: 600px) {
		background-color: transparent;
		line-height: 1.2;
		color: inherit;
		display: block;
		margin: 0;
		padding: 0 0 0.2em !important;

		${prop => {
			if (!prop.fontSizeOverride || prop.fontSizeOverride === 0) {
				switch (prop.md) {
					case 12:
					case 11:
					case 10:
					case 9:
					case 8:
					case 7:
					case 6:
						return `
							font-size: 5.867vw;

						`

					default:
						return `
							font-size: 2rem;
							font-weight: 700;
						`
				}
			}
			return ''
		}}
	}
	${p =>
		p.fontSizeOverride !== 0 &&
		p.fontSizeOverride &&
		`font-size:${p.fontSizeOverride}rem!important`};
`
export default Headline
