import styled from 'styled-components'

const ArticlePreviewFooter: any = styled.div`
	z-index: 10;
	position: relative;
	order: 10;
	text-align: right;
	margin-top: auto;
	display: flex;
	flex-direction: row;
	justify-content: flex-start;
	padding-top: 0.35rem;
	line-height: 1;

	span {
		flex-grow: 1;
		text-align: left;
		color: ${prop => {
			switch (prop.colorTheme) {
				case 'black':
				case 'primary':
				case 'green':
					return '#fff'
				case 'yellow':
				case 'secondary':
				default:
					return '#595661'
			}
		}};
		font-size: 1.4rem;
		display: block;
	}
`

export default ArticlePreviewFooter
