import React from 'react'
import { withTheme } from 'styled-components'

import SolPlug from '@aller/shared/components/SolPlug/Plug/SolPlug'
import { getColor } from '@aller/shiny/src/utils/get-color'

import { percentageToGridValues } from '../../../utils/percentage-to-grid-values'
import { standardizeArticleFromLabrador } from '../../../utils/standardize-articles/from-labrador'
import { useIsMobile } from '../../../hooks/useIsMobile'

interface Props {
	[x: string]: any
}

export function getLabelColor(name: string = '') {
	const colorName = name.replace(/\s/g, '').toLowerCase()
	return getColor(colorName)
}

const LabradorArticlePreview: React.FC<Props> = data => {
	const { theme, identifier, parentWidth = [], ...rest } = data
	let { column = {} } = data

	let fontColumnSizes = { ...column }

	const topnormal = identifier === 'topnormal'
	if (topnormal) {
		if (parentWidth[1] && parentWidth[1].type === 'Labrador_Column') {
			fontColumnSizes = percentageToGridValues(parentWidth[1].value)
		}
		column = {
			xs: 12,
			sm: 12,
			md: 12,
			lg: 12,
		}
	}

	if (useIsMobile()) {
		column = {
			xs: 12,
			sm: 12,
			md: 12,
			lg: 12,
		}
	}

	const article = JSON.parse(JSON.stringify(data)) // deep clone
	article.column = column
	const labradorArticleProps = standardizeArticleFromLabrador(article)

	const {
		labrador: { metadata: { boxBackground: { desktop: colorTheme = '' } = {} } = {} } = {},
		dataLabel,
	} = labradorArticleProps

	const props = {
		...rest, // must be added first. It may contain prop-names we set below
		...labradorArticleProps,
		colorTheme,
		fontColumnSizes,
		labelColor: dataLabel ? getLabelColor(dataLabel) : undefined,
	}

	// Should probably add some logic to support different types of plugs depending on site
	return <SolPlug {...props} />
}

export default withTheme(LabradorArticlePreview)
