import styled from 'styled-components'

import { BlockLink } from '@aller/shiny/src/atoms/BlockLink'

const PlugLink = styled(BlockLink)`
	height: 100%;
	color: inherit;
	text-decoration: none;
	background: ${prop => (prop.isBlack ? '#222' : '#fff')};
	display: block;
	display: flex;
	flex-flow: ${prop => (prop.flexDirectionRow ? 'row' : 'column')};
	box-shadow: 0 1px 4px -1px rgba(20, 20, 60, 0.08);
	z-index: 1;
	position: relative;
	&:hover {
		text-decoration: none;
	}

	${prop =>
		prop.isNativeAdvertisement &&
		`
			border-top: 3px solid;
			border-bottom: 3px solid;
			border-color: #23ACCC;
		`}
`

export default PlugLink
