import styled from 'styled-components'
import { getColor } from '@aller/shiny/src/utils/get-color'
import { getVariable } from '@aller/shiny/src/utils/get-variable'

const Section = styled.section`
	position: relative;
	padding-bottom: ${getVariable('verticalBase')};
	padding-top: ${getVariable('verticalBase')};
	background-color: ${getColor('background')};

	&.advertisement {
		height: auto;
		background-color: transparent;
		padding: 0;
		width: 100%;
		z-index: 0;
	}

	&.article {
		height: auto;
		background-color: transparent;
		width: 100%;
		// Quick fix for hiding wallpaper ads which are ultra wide
		overflow: hidden;
	}
`

export default Section
