import React from 'react'
import propTypes from 'prop-types'
import logger from '../../utils/log'

const { deprecated } = logger('Script')

/* eslint-disable react/no-danger,no-unused-vars */
const Script = ({ code, src, path, id, themeName, elementType, ...props }) => {
	// this is just a hack to see if we get a performance boom by delaying GTM (https://github.com/dbmedialab/wolverine-frontend/issues/858)
	// this also makes a bug, that we do not have GMT on Seher pages other then articles!
	if (src === 'https://www.googletagmanager.com/gtm.js?id=GTM-MTQKPS' && themeName === 'SeHer') {
		return null
	}

	if (src && id) {
		return <script {...props} dangerouslySetInnerHTML={{ __html: scriptSrc(id, src, props) }} />
	}
	// to not pass src as a prop when we do not have src
	if (src) {
		deprecated(`Please provide an ID to make sure that the url is not loaded twice: ${src}`)
		return <script {...props} src={src} dangerouslySetInnerHTML={{ __html: code }} />
	}

	return <script {...props} dangerouslySetInnerHTML={{ __html: code }} />
}

// We are spreading props in render-children, which makes React warn us thinking we might want some fields
//  as DOM attributes and that we not use e.g. `elementType` but `element-type` instead.
// These prop types have been added to remove props that produce warnings when spreading rest:
// - elementType
Script.propTypes = {
	code: propTypes.string,
	src: propTypes.string,
	path: propTypes.string,
	id: propTypes.string,
	themeName: propTypes.string,
	elementType: propTypes.string,
}
Script.defaultProps = {
	code: null,
	src: null,
	path: null,
	id: null,
	themeName: null,
	elementType: '',
}

function scriptSrc(id, src, { async = true }) {
	return `(function(d, s, id){
		var js, fjs = d.getElementsByTagName(s)[0];
		if (d.getElementById(id)){ return; }
		js = d.createElement(s); js.id = id;
		js.src = "${src}";
		js.async = ${async};
		fjs.parentNode.insertBefore(js, fjs);
	})(document, 'script', '${id}')`
}

export default Script
