import React, { memo } from 'react'
import PropTypes from 'prop-types'
import Head from 'next/head'

const RowFragmentList = ({ rows }) => {
	return (
		<>
			<Head>
				<link rel="stylesheet" href="//styleguide.dagbladet.no/stylesheets/core.css" />
				<link rel="stylesheet" href="//styleguide.dagbladet.no/stylesheets/app.css" />
			</Head>
			<div className="labrador-container" style={{ fontSize: '100%' }}>
				{rows.map((row, i) => (
				<div dangerouslySetInnerHTML={{ __html: row }} key={`row-${i}`} /> // eslint-disable-line
				))}
			</div>
		</>
	)
}
RowFragmentList.propTypes = {
	rows: PropTypes.arrayOf(PropTypes.string),
}
RowFragmentList.defaultProps = {
	rows: [],
}

export default memo(RowFragmentList)
