import styled from 'styled-components'
import React from 'react'
import { Row as ShinyRow } from '@aller/shiny/src/atoms/Row'
import propTypes from 'prop-types'

const RowStyle = styled(ShinyRow)`
	flex-grow: 1;
	flex-shrink: 1;
	flex-basis: auto;
`

const Row = ({ children }) => {
	return <RowStyle>{children}</RowStyle>
}

Row.propTypes = {
	children: propTypes.oneOfType([propTypes.arrayOf(propTypes.node), propTypes.node]).isRequired,
}

export default Row
