import React from 'react'
import PropTypes from 'prop-types'
import styled from 'styled-components'
import Col from '../Col'

const RightLaneComponent = styled(Col)`
	@media (min-width: ${props => props.theme.flexboxgrid.breakpoints.md}em) {
		flex-basis: 33.4rem;
		max-width: 33.4rem;
	}
`

// see next.config.js for components that does this
export default class RightLane extends React.Component {
	componentDidMount() {}

	render() {
		return <RightLaneComponent {...this.props} />
	}
}

RightLane.propTypes = {
	elementName: PropTypes.string,
	abTest: PropTypes.string,
	modules: PropTypes.array, // eslint-disable-line react/forbid-prop-types
	context: PropTypes.object, // eslint-disable-line react/forbid-prop-types
	columnCounter: PropTypes.number,
}

RightLane.defaultProps = {
	elementName: 'div',
	context: {},
	abTest: '',
	modules: [],
	columnCounter: 0,
}
