// Dependencies
import React from 'react'
import PropTypes from 'prop-types'

// Components for this module
import { DotLoader as Loading } from '@aller/shiny/src/atoms/loaders/DotLoader'
import Main from './PercentagesOfPublished'
import Screen from '../Screen'

// Decorators
import withData from '../../decorators/with-data'

// Services
import getData from './services/get-data'

// Our data fetching React component
const ExampleWithData = ({ isLoadingData, error, ...rest }) => {
	if (error) {
		return <div>Oops, something went wrong.</div>
	}
	// Handle data loading if you want
	// a loading indicator and not "dead" data:
	// Until we have data,
	// show a loading indicator
	if (isLoadingData) {
		return (
			<Screen color="burgundy" center>
				<Loading />
			</Screen>
		)
	}

	// The actual stuff you want to show
	return <Main {...rest} />
}
ExampleWithData.propTypes = {
	error: PropTypes.bool.isRequired,
	isLoadingData: PropTypes.bool.isRequired,
}

// Finally export the module
export default withData({
	fetchData: getData,
	dataProp: 'data',
	loadingProp: 'isLoadingData',
})(ExampleWithData)
