/**
 * This is a fork of Shiny's ShinyThemeProvider without Global styles.
 */

/* eslint-disable max-len, import/prefer-default-export */
import React from 'react'
import propTypes from 'prop-types'
import { ThemeProvider as StyledThemeProvider } from 'styled-components'
import { merge } from 'aurora-deep-slice-merge'

import defaultTheme from '@aller/shiny/src/themes/default-theme'
import { themePropTypes } from '@aller/shiny/src/themes/theme-prop-types'

/**
 * An extension of styled-component's ThemeProvider.
 *
 * Why do we need this, you might ask? In addition to what we
 * get from styled-components, this ThemeProvider:
 * - deep merges our theme with the default theme
 * - injects our theme's global styles
 */
const NoGlobalsShinyThemeProvider = ({ children, theme }) => {
	// Deep merge the chosen theme with our default theme.
	// This way, we can always assume that every property
	// in the default theme will have a value
	// no matter which theme we are using
	const mergedTheme = merge(defaultTheme, theme)
	// console.log(`Switching to the ${themeName} theme.`);
	// console.log('new theme', theme.name);

	/**
	 * TODO: Make that inner div a React.Fragment
	 *
	 * aurora-frontend is still not on Fiber. ThemeProvider expects an only child.
	 */
	return (
		<StyledThemeProvider theme={mergedTheme}>
			<>{children}</>
		</StyledThemeProvider>
	)
}
NoGlobalsShinyThemeProvider.propTypes = {
	theme: propTypes.shape(themePropTypes),
	children: propTypes.oneOfType([propTypes.arrayOf(propTypes.node), propTypes.node]),
}
NoGlobalsShinyThemeProvider.defaultProps = {
	children: null,
	theme: {},
}

export { NoGlobalsShinyThemeProvider }
