/* eslint-disable import/prefer-default-export */

import styled from 'styled-components'
import { getVariable, getColor } from '@aller/shiny/src/utils'

export const Article = styled.article`
	float: right;
	width: 200px;
	overflow: hidden;
	margin: 0 1.4rem calc(${getVariable('verticalBase')} / 2) 0;
	@media screen and (max-width: 600px) {
		display: none;
	}
`

export const Link = styled.a`
	border-bottom: 0;
	color: ${getColor('darkness', 'light')};
	text-decoration: none;
	&:hover {
		color: ${getColor('darkness', 'light')};
	}
`

export const Image = styled.img`
	width: 100%;
	margin-top: calc(${getVariable('verticalBase')} / 1.5);
`

export const Title = styled.h4`
	font-size: ${getVariable('headingSmallSize')};
	padding: 1rem 0;
	font-weight: 700;
`

export const Description = styled.p`
	margin-bottom: calc(${getVariable('verticalBase')} / 2);
	font-size: ${getVariable('uiRegularSize')};
`
