import axios from 'axios'
import qs from 'query-string'

export default function fetchArticles(options) {
	const apiUrl = buildUrl(options)

	return axios
		.get(apiUrl, {
			timeout: options.timeout,
		})
		.then(response => response.data.items)
}

function buildUrl(options) {
	const {
		categoryData: {
			includeHosts,
			includeAnyTags,
			excludeTags,
			onlyOneHost = '', // 'onlyOneHost' does not exist on all categories
		},
		limit,
		timeout,
		offset,
	} = options

	const responseFilter = ['title', 'url', 'host', 'posted', 'fields.image', 'fields.description']

	const data = {
		includeHosts: onlyOneHost ? onlyOneHost : includeHosts,
		includeAnyTags,
		excludeTags,
		limit,
		offset,
		timeout,
		tagFields: 'article_tags2',
		excludePaywall: true,
		excludeDupes: 96,
		responseFilter: responseFilter.join(','),
	}

	return `https://sol.no/app/harvester-webservice/get?${qs.stringify(data)}`
}
